﻿function manualDialing() {

    //
    //  m_Config  ...           espace qui contient les proprietes du projet et les propriete de configuration
    //  m_ToolBar ...           Frame du toolbar
    //  m_closeSentinelFrame    Frame cache qui contient un fouillit de function et de variable ... Responsable de requete ajax
    //  m_DialPad               Object de control du dialpad. Code source trouvé sur internet
    //  m_PhoneNumber           Numero de telephone de la fiche ( record de base de donnees )
    //  m_WebServiceUrl         Url de voxco.agent.webservice
    //  m_DialCssLink           Url absolue pour le css du dialpad
    //  m_DialogCssLink         Url absolue pour le css qui permet l'overlay du dialpad sur la page de intweb
    //  m_UserId                UserId 
    //  m_MyDivObject           Variable qui contient le div injecte 
    //  m_IntWebNextButton      Le nom du bouton next de Intweb


    var m_dialingInstance = this;
    m_dialingInstance.m_defaultCallBack = {} ;

    
    m_dialingInstance.m_Config = null;
    m_dialingInstance.m_ToolBar = null;
    m_dialingInstance.m_closeSentinelFrame = null;
    m_dialingInstance.m_DialPad = null;
    m_dialingInstance.m_PhoneNumber = null;
    m_dialingInstance.m_WebServiceUrl = "" ;
    m_dialingInstance.m_DialCssLink = "";
    m_dialingInstance.m_DialogCssLink = "";
    m_dialingInstance.m_bDialing = false;
    m_dialingInstance.m_UserId = "";
    m_dialingInstance.m_Dialing = "dialing" ;
    m_dialingInstance.m_DialingFailed = "dialing failed";
    m_dialingInstance.m_bConnected = false;
	m_dialingInstance.m_MyDivObject = "" ;
    m_dialingInstance.m_IntWebNextButton = "" ;
    m_dialingInstance.m_CloseButtonEnabled = true;
    m_dialingInstance.m_iDialPadDialingTimerId = 0;
    //
    //  Initialisation de l'objet.. l'init est appele qu'une seule fois au demnarrage de Voxco.agebt
    //
    //      1) creation du dial pad
    //      2) Initialisaton des variables internes .
    //
    this.init = function ( userid , callback ) {

        if (AgentAssignment.isManualDialingProject() == false) {
            return;
        }
       

        m_dialingInstance.Create();
        m_dialingInstance.SetDefaultCallback(callback);
        if (m_dialingInstance.m_DialPad != null) {

            if (typeof gCustomDialPad !== "undefined") {
                info("DialPad.init> dialpad callback has been overloaded. Re-allocate dialpad object ");
                m_dialingInstance.m_DialPad = new Dialpad(m_dialingInstance.m_defaultCallBack);
            }

            return;
        }

        m_dialingInstance.m_UserId = userid;
        m_dialingInstance.m_DialPad = new Dialpad( m_dialingInstance.m_defaultCallBack ) ;
                

        //
        //  Nous gardons en memoire les differents label text pour ne pas les demander constanment 
        //
       
     
        m_dialingInstance.m_Dialing       = m_dialingInstance.m_ToolBar.getVAResourceValue("STR_Dialing");
        m_dialingInstance.m_DialingFailed = m_dialingInstance.m_ToolBar.getVAResourceValue("STR_Dialing") + ' ' + m_dialingInstance.m_ToolBar.getVAResourceValue("STR_FAILED");
      
    
        m_dialingInstance.m_DialPad.setLabel(m_dialingInstance.m_DialPad.dialLabel, m_dialingInstance.m_ToolBar.getVAResourceValue( "STR_Dial") );
    }

    this.Create = function () {

        if (typeof m_dialingInstance.m_Config == "object" && m_dialingInstance.m_Config != null )
            return;

        createClassManager();
        m_dialingInstance.m_Config = gClassManager.getConfigManager();
        m_dialingInstance.m_ToolBar = gClassManager.getToolbar();
        m_dialingInstance.m_closeSentinelFrame = gClassManager.getCloseSentinelFrame();
        return;
    }

    this.cleanNumber = function (number) {
        var str = number;
        var len = str.length;
        var value = '';

        for (idx = 0; idx < len; ) {
            var digit = str.charAt(idx);
            if (isNaN(digit) == false && digit != ' ' ) {
                value += digit;
            }
            else {
                var code = str.charCodeAt(idx);
                 warning("DialPad.cleanNumber> warning: phone number as invalid character: 0x" + code.toString(16) + " at position: " + idx);
            }                   

            idx++;
        }

        return value;
    }

    this.onCall = function (number) {

        var bMatch = false;
        var numberClean = m_dialingInstance.cleanNumber(number);
        var phoneNumberClean = m_dialingInstance.cleanNumber(m_dialingInstance.m_PhoneNumber);
        if (phoneNumberClean == numberClean) {
            bMatch = true;
        } else {
            warning("DialPad.onCall> warning: phone number enter does not match the phone number in the record. record( " + phoneNumberClean + " )" + "!= Dialed ( " + numberClean + " )");
        }

        m_dialingInstance.Send(bMatch);
        return;
    }


    this.onHide = function (number) {
        m_dialingInstance.m_MyDivObject.style.visibility = 'hidden';
        debug("DialPad.onHide> Hiding dialpad ... The phone number dialed was : " + m_dialingInstance.m_PhoneNumber);
    }


    this.onClose = function () {
        debug("DialPad.onClose> The close button has been pressed by the agent.The phone number was " + m_dialingInstance.m_PhoneNumber);
    }

    this.onPress = function (key) {
    }



    this.onCallableNumber = function (number) {
        var numberClean = m_dialingInstance.cleanNumber(number);
        var phoneNumberClean = m_dialingInstance.cleanNumber(m_dialingInstance.m_PhoneNumber);
        if (phoneNumberClean != numberClean) {
            warning("DialPad.onCallableNumber> warning: phone number enter does not match the phone number in the record. record( " + phoneNumberClean + " )" + "!= Dialed ( " + numberClean + " )");
        }
    }

    this.SetDefaultCallback = function( usercallback )
    {
       
        var callbacks = ['onPress', 'onHide', 'onCallableNumber', 'onCall', 'onClose', 'onTimeout'];

        m_dialingInstance.m_defaultCallBack["onPress"]          = m_dialingInstance.onPress;
        m_dialingInstance.m_defaultCallBack["onHide"]           = m_dialingInstance.onHide;
        m_dialingInstance.m_defaultCallBack["onCallableNumber"] = m_dialingInstance.onCallableNumber;
        m_dialingInstance.m_defaultCallBack["onCall"]           = m_dialingInstance.onCall;
        m_dialingInstance.m_defaultCallBack["onClose"]          = m_dialingInstance.onClose;
        m_dialingInstance.m_defaultCallBack["onTimeout"]        = m_dialingInstance.OnDialPadTimeout;

        if (usercallback == undefined || usercallback == null)
            return;
       

        for(  var item in callbacks )
        {
            name = callbacks[item];
            if (usercallback[name] != undefined && usercallback[ name ] != null)
                m_dialingInstance.m_defaultCallBack[name] = usercallback[name];
        }
    }

    this.DialCompletion = function( bSuccess )
    {
        if (typeof bSuccess == "boolean" && bSuccess == false)
        {
            m_dialingInstance.m_bDialing = false;
            return;
        }
       
        //
        //  Avec la compostion manuel, nous forcons l'execution des commandes pronto 
        //  au cas ou le mask de composition est associe avec un mask RECORD ou autre MASK
        //
        //  Pour la composition manuel , nous ne pouvons pas envoye aucun autre mask tant et 
        //  aussi longtemps que l'agent n'a pas appuye sur le bouton DIAL
        //
        if (typeof m_dialingInstance.m_closeSentinelFrame.executeProntoCommand == "function")
            setTimeout(m_dialingInstance.m_closeSentinelFrame.executeProntoCommand, 1);

        
        return;
    }

    this.getDialPadResources = function()
    {
        var diapadresources = { "dialpadHtmlElement": m_dialingInstance.m_MyDivObject, "dialpadFrame": gClassManager.getSharedFrame() };
        return diapadresources;
    }
    //
    //  Envoie de la command dial a l'engin de telephonie..
    //
    this.Send = function (  bMatched ) {

        try
        {
            //
            //  On compose le numero si et seulement si il correspond au numero du record de la base
            //  donnee... TODO besoin d'un label...
            //

            if (m_dialingInstance.m_bDialing == true) {
                warning("DialPad.onCall> Sorry! But the system is already dialing for you. Number dialed: " + m_dialingInstance.m_PhoneNumber);
                return;
            }

            if (bMatched == false) {
                m_dialingInstance.setMandoryButton(false, "number mismatched");
                return;
            }

            m_dialingInstance.stopDialpadTimer();
            
            //
            // m_dialingInstance.m_bDialing = true ... empeche l'envoie du message dial si l'agent appuie plusieurs fois sur le 
            // bouton dial. Comme ce .js appartient au frame close sentinel , l'etat des variables de cet objet
            // est permanent
            //

            m_dialingInstance.m_bDialing = true;
            DIALRequest.setDialCompletionCallBack(m_dialingInstance.DialCompletion);
            DIALRequest.execute(m_dialingInstance.m_UserId);
         

           
            debug("DialPad.Send> Command dial has been sent to telephony server -- " + m_dialingInstance.m_PhoneNumber);
        }
        catch (e) {

            //
            //  oups un exception... remet le bouton next de intweb pour permettre a l'agent de
            //  continuer la navigation
            //

            m_dialingInstance.stopDialpadTimer();

            if (m_dialingInstance.m_bDialing == false) {
                setMandoryButton(true, m_dialingInstance.m_DialingFailed );
            }
           
            m_dialingInstance.m_bDialing = false;
            error("DialPad.Send> caught an exception in the send command exception:  " + e.message + ". Phone number dialed " + m_dialingInstance.m_PhoneNumber);
        }
    }

    //
    //  Affichage des status ( dialing , dial failed , connected ... )
    //
    this.setMandoryButton = function ( enable , status ) {

        if (enable != undefined && enable != null) {
            var shareFrame = gClassManager.getSharedFrame();
            m_dialingInstance.m_closeSentinelFrame.enableIntWebCtrl(shareFrame, m_dialingInstance.m_IntWebNextButton, enable);
        }

        if (status != undefined && status != null) {
            m_dialingInstance.m_ToolBar.setStatusMsg( status ) ;
        }

        return ;
    }

   
    //
    //  Construction des url pour :
    //
    //  1) le url,  en abosolue, pour injecter les CSS essentiels au document intweb
    //  2) Le url , en absolue , pour la localisation du webservice.
    //

    this.setAbsolutePath = function( location )
    {

        m_dialingInstance.m_WebServiceUrl = location.protocol + '//' + location.hostname + '/Voxco.Agent.WebService/PHService.asmx';

        m_dialingInstance.m_DialCssLink   = "<link rel=\"stylesheet\" href=" + "\"/Voxco.Agent/js/dialpad.css\"" + "type=\"text/css\" />";
        m_dialingInstance.m_DialogCssLink = "<link rel=\"stylesheet\" href=" + "\"/Voxco.Agent/css/smoothness/jquery-ui-1.10.3.custom.css\"" + "type=\"text/css\" />";
	}

    //
    //  fermeture du dialpad
    //

    this.Close = function ( dialstatus ) {

        try {

            m_dialingInstance.m_bDialing = false;

            if (AgentAssignment.isManualDialingProject() == true && m_dialingInstance.m_DialPad != null) {

                debug("DialPad.Close> The dial is completed ... Closing dial pad.");
                m_dialingInstance.m_DialPad.hide();

                if (dialstatus != undefined && dialstatus == "ERR") {
                    error("DialPad.Close> An error occured when dialing phone number " + m_dialingInstance.m_PhoneNumber + ". Dial pad will be closed...");
                    m_dialingInstance.m_DialPad.clear();
                    return;
                }

                m_dialingInstance.m_bConnected = true;
                debug("DialPad.Close> The dial is completed ... Closing dial pad.");
            }
        }
        catch (e) {
            error("DialPad.Close> Not able to close dial pad dialog... caught an exception: " + e.message);
        }
       
        return;
    }

    this.OnDialPadTimeout = function () {

   
        var dialpadFrame = gClassManager.getSharedFrame();

        var backgroundcolor = m_dialingInstance.m_Config.getBackgroundColor();
        dialpadFrame.document.body.style.background = backgroundcolor;

        debug("DialPad.OnDialPadTimeout> The dialing digit is to long.. Changing backgroup color to " + backgroundcolor);
        return;
    }

    this.Disconnect = function () {

        m_dialingInstance.stopDialpadTimer();

        if (m_dialingInstance.m_bConnected == true) {
            m_dialingInstance.m_bConnected = false;
            debug("DialPad.Disconnect> the call has been dropped");
        }
    }


    //
    //  RenderDialPad  inject un element HTML pour l'affichage d'un dialpad au document de Intweb. Si nous avons un exception l'application poursuit le dial comme si
    //  nous etions en preview sans l'affichage du dial pad.
    //
    this.RenderDialPad = function ( dialparam , nextButton,closeButtonEnabled ) {

        var bOk = false;
        
        try {


            if (AgentAssignment.isManualDialingProject() == false) {
                //
                //  Manual dialing n'est pas pour ce projet.
                //

                debug("DialPad.RenderDialPad> Not a manual dialing project. Let's do a normal preview call...");
                return bOk;
            }

            if (CallClass.isInCall() == true)
            {
                info("DialPad.RenderDialPad> The agent is on call ... no need to show dialpad.");
                return bOk;
            }

           
            bOk = true;
            //
            //  Nous gardons les information essentielles. 
            //
        
            //  2) Le numéro de telephone de la fiche   -- m_PhoneNumber
            //  3) Nom du bouton next de intweb         -- m_IntWebNextButton
            //  4) setDisplay() change le status et mise a jour du bouton next
            //

           
            debug("DialPad.RenderDialPad> This is a manual dialing project. Need to show dial pad to create call...");
            m_dialingInstance.m_PhoneNumber = m_dialingInstance.m_closeSentinelFrame.getValueOfFromParams("phoneno", dialparam);
            m_dialingInstance.m_IntWebNextButton = nextButton;
            m_dialingInstance.m_bDialing = false;
            m_dialingInstance.m_CloseButtonEnabled = closeButtonEnabled;
            m_dialingInstance.setDisplay(closeButtonEnabled);

            
            debug("DialPad.RenderDialPad> inserting manual dialing pad in the intweb document");
           
            //
            //  getShareFrame est le frame partagé pour la selection de projet et les documents de IntWeb. Durant l'entrevue le frame f2 est occupé par IntWeb
            //
            //  1) className -- css de jquery pour permettre l'overlay du dialpad. Normalement le dialpad est positionne par dessus la page de IntWeb
            //  2) Nous injectons au document de intweb une importation du CSS pour le dial pad et pour jquery 
            //
            //

            var dialpadFrame = gClassManager.getSharedFrame();

            //
            //  Assure une compatibilite avec IE7 et IE8. Si createStyleSheet n'est pas utilisé , aucun chargement du CSS n'est possible
            //
            if (dialpadFrame.document.createStyleSheet == undefined || dialpadFrame.document.createStyleSheet == null) {
                $(dialpadFrame.document.head).append(m_dialingInstance.m_DialCssLink);
                $(dialpadFrame.document.head).append(m_dialingInstance.m_DialogCssLink);
            }
            else {
                dialpadFrame.document.createStyleSheet('/voxco.agent/js/dialpad.css');
                dialpadFrame.document.createStyleSheet('/voxco.agent/css/smoothness/jquery-ui-1.10.3.custom.css');
            }

		
			m_dialingInstance.m_MyDivObject = dialpadFrame.document.createElement("div");
			m_dialingInstance.m_MyDivObject.style.visibility = 'visible';
			m_dialingInstance.m_MyDivObject.id = 'myDialPad';
            m_dialingInstance.m_MyDivObject.className = "ui-dialog ui-widget ui-widget-content ui-corner-all ui-front ui-dialog-buttons ui-draggable";
			m_dialingInstance.m_MyDivObject.style.left = '40%';
            m_dialingInstance.m_MyDivObject.style.top = '20%';
            m_dialingInstance.m_MyDivObject.style.width = 'auto' ;
            m_dialingInstance.m_MyDivObject.style.height = 'auto' ;
          
            //
            //  Rendering du dialpad
            //
                   
            m_dialingInstance.m_MyDivObject.appendChild(m_dialingInstance.m_DialPad.render(null, m_dialingInstance.m_PhoneNumber, $(gClassManager.getSharedFrame().document.body), m_dialingInstance.m_CloseButtonEnabled));

            dialpadFrame.document.body.appendChild(m_dialingInstance.m_MyDivObject);
            m_dialingInstance.m_DialPad.addDocListener($(gClassManager.getSharedFrame().document.body).find('.dialerwrapper'));

            var iTimeout = m_dialingInstance.m_Config.getOnDialPadTimeout() * 1000;
            if (iTimeout != 0) {
                info("DialPad.RenderDialPad> Setting on dial pad dialing timeout to " + iTimeout);
                m_dialingInstance.m_iDialPadDialingTimerId = setTimeout(m_dialingInstance.OnDialPadTimeout, iTimeout);
            }

        }
        catch (e) {

            //
            //  Une exception.... Dans le code ( closesentinel.aspx ) nous continuons le dial comme si c'etait un appel preview. 
            //
      
            error("DialPad.RenderDialPad> caught an exception while rendering dial pad in the intweb document. Exception:  " + e.message);
            bOk = false;
        }

        return bOk ;
    }


    this.stopDialpadTimer = function () {

        if (m_dialingInstance.m_iDialPadDialingTimerId != 0) {
            debug("DialPad.stopDialpadTimer> stopping timer id  " + m_dialingInstance.m_iDialPadDialingTimerId + ". No need to change background color");
            clearTimeout(m_dialingInstance.m_iDialPadDialingTimerId);
            m_dialingInstance.m_iDialPadDialingTimerId = 0;
        }
    }

    //
    //	On s'assure que l'affichange est coherent surtout dans les cas de redial avec le dialpad ... Sinon c'est le dernier display qui demeure
    //	a l'ecran.
    //
    //	Les informations refraichies sont:  le dernier status d'appel et le symbole ou l'image du status
    //
    this.setDisplay = function () {

        
        try {
            m_dialingInstance.setMandoryButton(enable, null);
            m_dialingInstance.m_ToolBar.setLastCallResultMsg("");
            //
            //  on remet l'image a idle dans le cas ou l'agent effectue un redial ...
            //

            var _txt = m_dialingInstance.m_ToolBar.document.getElementById('statusTxt');
            _txt.innerHTML = m_dialingInstance.m_ToolBar.getVAResourceValue("STR_Paused");

             var _img = m_dialingInstance.m_ToolBar.document.getElementById("statusImg");
            _img.style.display = "inline";
            _img.src = "./Images/ico16_pause.gif";
        }
        catch (e) {
            //
            //  Pas important de savoir... Nous essayons de mettre a jour une image. Si ca echoue c'est tant pis 
            //
        }
    }
}

gManualDialing = new manualDialing;